
/*************  ˵    **************

̻AI8051UΪоƬʵV1.1汾бдԡ

ʹKeil C51,Ϊ˴ﵽȽϸߵЧ,һ㽨ѡ"Small"ģʽ

 "error C249: 'DATA': SEGMENT TOO LARGE" ʱҪֱֶȽϴͨ"xdata" ǿƷ䵽 XDATA (: char xdata buffer [256];)

ɫOLED12864ʾICΪSSD1306SPIӿڣͨSPI DMA1024ֽڵͼƬ͵ʱռCPUʱ䡣

ʾͼΣ֣Ӣģ.

ͼʾͼƬʹSPI DMAʱռCPUʱ䡣GUIˣȲxdata1024ֽڻ棬Ȼ󴥷SPI DMAɣ523us943usԼˢꡣ
40MHz, SPIٶΪƵ4Ƶ(10MHz)ÿSPI DMAʱ943usSPIٶΪƵ2Ƶ(20MHz)ÿSPI DMAʱ523us

Ҫʾݷ1024ֽڵԴУDMA伴ɡ

ʱ, ѡʱ 40MHz (û޸Ƶʺ±뼴).

******************************************/


	#define	MAIN_Fosc	40000000UL


	#include "../comm/AI8051U.h"
	#include	"ASCII6x8.h"
	#include	"HZK16.h"
	#include	"ASCII-10x24.h"
	#include	"picture1.h"
	#include	"picture2.h"

typedef 	unsigned char	u8;
typedef 	unsigned int	u16;
typedef 	unsigned long	u32;
#define	Pin0		0x01	//IO Px.0
#define	Pin1		0x02	//IO Px.1
#define	Pin2		0x04	//IO Px.2
#define	Pin3		0x08	//IO Px.3
#define	Pin4		0x10	//IO Px.4
#define	Pin5		0x20	//IO Px.5
#define	Pin6		0x40	//IO Px.6
#define	Pin7		0x80	//IO Px.7
#define	PinAll		0xFF	//IO
#define P1n_standard(bitn)			P1M1 &= ~(bitn),	P1M0 &= ~(bitn)
#define P1n_push_pull(bitn)			P1M1 &= ~(bitn),	P1M0 |=  (bitn)
#define P1n_pure_input(bitn)		P1M1 |=  (bitn),	P1M0 &= ~(bitn)
#define P1n_open_drain(bitn)		P1M1 |=  (bitn),	P1M0 |=  (bitn)

#define P2n_standard(bitn)			P2M1 &= ~(bitn),	P2M0 &= ~(bitn)
#define P2n_push_pull(bitn)			P2M1 &= ~(bitn),	P2M0 |=  (bitn)
#define P2n_pure_input(bitn)		P2M1 |=  (bitn),	P2M0 &= ~(bitn)
#define P2n_open_drain(bitn)		P2M1 |=  (bitn),	P2M0 |=  (bitn)

#define P3n_standard(bitn)			P3M1 &= ~(bitn),	P3M0 &= ~(bitn)
#define P3n_push_pull(bitn)			P3M1 &= ~(bitn),	P3M0 |=  (bitn)
#define P3n_pure_input(bitn)		P3M1 |=  (bitn),	P3M0 &= ~(bitn)
#define P3n_open_drain(bitn)		P3M1 |=  (bitn),	P3M0 |=  (bitn)

#define P4n_standard(bitn)			P4M1 &= ~(bitn),	P4M0 &= ~(bitn)
#define P4n_push_pull(bitn)			P4M1 &= ~(bitn),	P4M0 |=  (bitn)
#define P4n_pure_input(bitn)		P4M1 |=  (bitn),	P4M0 &= ~(bitn)
#define P4n_open_drain(bitn)		P4M1 |=  (bitn),	P4M0 |=  (bitn)

//=============================================================================================================
#define	PullUpEnable(port, pu)		port |=  (pu)		/* ˿ڲ       PxPU, ҪõĶ˿ڶӦλΪ1 */
#define	PullUpDisable(port, pu)		port &= ~(pu)		/* ֹ˿ڲ(Ĭ) PxPU, ҪõĶ˿ڶӦλΪ1 */
#define	PullDownEnable(port, pu)	port |=  (pu)		/* ˿ڲ       PxPD, ҪõĶ˿ڶӦλΪ1 */
#define	PullDownDisable(port, pu)	port &= ~(pu)		/* ֹ˿ڲ(Ĭ) PxPD, ҪõĶ˿ڶӦλΪ1 */
#define	SchmitEnable(port, smt)		port &= ~(smt)		/* ˿ʩش(Ĭ) PxNCS, ҪõĶ˿ڶӦλΪ1 */
#define	SchmitDisable(port, smt)	port |=  (smt)		/* ˿ʩش       PxNCS, ҪõĶ˿ڶӦλΪ1 */
#define	SlewRateNormal(port, sr)	port |=  (sr)		/* ˿Ϊͨٶ(Ĭ) PxSR, ҪõĶ˿ڶӦλΪ1 */
#define	SlewRateHigh(port, sr)		port &= ~(sr)		/* ˿Ϊģʽ       PxSR, ҪõĶ˿ڶӦλΪ1 */
#define	CurrentNormal(port, cu)		port |=  (cu)		/* ˿Ϊͨģʽ(Ĭ) PxDR, ҪõĶ˿ڶӦλΪ1 */
#define	CurrentHigt(port, cu)		port &= ~(cu)		/* ˿Ϊģʽ     PxDR, ҪõĶ˿ڶӦλΪ1 */
#define	InputEnable(port, ie)		port |=  (ie)		/* ˿(Ĭ) PxIE, ҪõĶ˿ڶӦλΪ1 */
#define	InputDisable(port, ie)		port &= ~(ie)		/* ֹ˿       PxIE, ҪõĶ˿ڶӦλΪ1 */
#define	BypassEnable(port, bp)		port &= ~(bp)		/* Զƶ˿       PxBP, ҪõĶ˿ڶӦλΪ1 */
#define	BypassDisable(port, bp)		port |=  (bp)		/* ֹԶƶ˿(Ĭ) PxBP, ҪõĶ˿ڶӦλΪ1 */
//=============================================================================================================


//************************************************************************************************

/****************************** IO ***********************************/
/*	ӿ	*/
							//GND	AI8051Uʵ V1.1
							//VCC	3~5V
sbit P_OLED_CLK	=  	P3^2;	//D0	SPI or II2 ʱӽ
sbit P_OLED_DIN	=   P3^3;	//D1	SPI or II2 ݽ
sbit P_OLED_RST	=  	P4^7;	//RES	λ, ͵ƽλ
sbit P_OLED_DC	=  	P1^1;	//DC	ݻ
sbit P_OLED_CS	=	P3^5;	//CS	Ƭѡ


/*****************************************************************************/

/*************  س    **************/


/*************  ر    **************/
u16	SPI_TxCnt;		//SPI DMAʹ, һ128ֽ, һ8
bit	B_SPI_DMA_busy;	//SPI DMAæ־ 1־SPI-DMAæSPI DMAж˱־ʹSPI DMAǰҪȷϴ˱־Ϊ0
u16	SPI_TxAddr;		//SPI DMAҪݵ׵ַ
bit	B_TxCmd;		//ѷ־
u8 xdata CmdTmp[5];	//


/*************  غ    **************/




//========================================================================
// : void  SPI_Config(u8 SPI_io, u8 SPI_speed)
// : SPIʼ
// : io: лIO,            SS  MOSI MISO SCLK
//                       0: л P1.4 P1.5 P1.6 P1.7
//                       1: л P2.4 P2.5 P2.6 P2.7
//                       2: л P4.0 P4.1 P4.2 P4.3
//                       3: л P3.5 P3.4 P3.3 P3.2
//       SPI_speed: SPIٶ, 0: fosc/4,  1: fosc/8,  2: fosc/16,  3: fosc/2
// : none.
// 汾: VER1.0
// : 2024-8-13
// ע:
//========================================================================
void  SPI_Config(u8 SPI_io, u8 SPI_speed)
{
	SPI_io &= 3;

	SPCTL = SPI_speed & 3;	//SPI ٶ, ִָ, ˳Bit7~Bit20
	SPCTL |= SSIG;	//1: SSţMSTRλǴӻ		0: SSھǴӻ
	SPCTL |= SPEN;	//1: SPI								0ֹSPISPIܽžΪͨIO
	SPCTL &= ~DORD;	//1LSBȷ								0MSBȷ
	SPCTL |= MSTR;	//1Ϊ								0Ϊӻ
	SPCTL |= CPOL;	//1: ʱSCLKΪߵƽ					0ʱSCLKΪ͵ƽ
	SPCTL |= CPHA;	//1: SCLKǰ,ز.			0: SCLKǰز,.
//	SPCTL &= ~SPR1;	//SPR1,SPR0   00: fosc/4,     01: fosc/8
//	SPCTL &= ~SPR0;	//            10: fosc/16,    11: fosc/2
	P_SW1 = (P_SW1 & ~0x0c) | ((SPI_io<<2) & 0x0c);		//лIO

	HSCLKDIV   = 1;					//HSCLKDIVʱӷƵ
	SPI_CLKDIV = 1;					//SPI_CLKDIVʱӷƵ
	SPSTAT = 0x80 + 0x40;			//0 SPIFWCOL־

	if(SPI_io == 0)
	{
		P1n_standard(0xf0);			//л P1.4(SS) P1.5(MOSI) P1.6(MISO) P1.7(SCLK), Ϊ׼˫
		PullUpEnable(P1PU, 0xf0);	//    ˿ڲ   PxPU, ҪõĶ˿ڶӦλΪ1
		P1n_push_pull(Pin7+Pin5);	//MOSI SCLKΪ
		SlewRateHigh(P1SR, Pin7+Pin5);	//MOSI SCLK˿Ϊģʽ   PxSR, ҪõĶ˿ڶӦλΪ1.    ģʽ3.3VʱٶȿԵ13.5MHz(27MHzƵSPIٶ2Ƶ)
	}
	else if(SPI_io == 1)
	{
		P2n_standard(0xf0);			//лP2.4(SS) P2.5(MOSI) P2.6(MISO) P2.7(SCLK), Ϊ׼˫
		PullUpEnable(P2PU, 0xf0);	//    ˿ڲ   PxPU, ҪõĶ˿ڶӦλΪ1
		P2n_push_pull(Pin7+Pin5);	//MOSI SCLKΪ
		SlewRateHigh(P2SR, Pin7+Pin5);	//MOSI SCLK˿Ϊģʽ   PxSR, ҪõĶ˿ڶӦλΪ1.    ģʽ3.3VʱٶȿԵ13.5MHz(27MHzƵSPIٶ2Ƶ)
	}
	else if(SPI_io == 2)
	{
		P4n_standard(0x0f);			//лP4.0(SS) P4.1(MOSI) P4.2(MISO) P4.3(SCLK), Ϊ׼˫
		PullUpEnable(P4PU, 0x0f);	//    ˿ڲ   PxPU, ҪõĶ˿ڶӦλΪ1
		P4n_push_pull(Pin3+Pin1);	//MOSI SCLKΪ
		SlewRateHigh(P4SR, Pin3+Pin1);	//MOSI SCLK˿Ϊģʽ   PxSR, ҪõĶ˿ڶӦλΪ1.    ģʽ3.3VʱٶȿԵ13.5MHz(27MHzƵSPIٶ2Ƶ)
	}
	else if(SPI_io == 3)
	{
		P3n_standard(0x3C);		//лP3.5(SS) P3.4(MOSI) P3.3(MISO) P3.2(SCLK), Ϊ׼˫
		PullUpEnable(P3PU, 0x3c);	//    ˿ڲ   PxPU, ҪõĶ˿ڶӦλΪ1
		P3n_push_pull(Pin4+Pin2);	//MOSI SCLKΪ
		SlewRateHigh(P3SR, Pin4+Pin2);	//MOSI SCLK˿Ϊģʽ   PxSR, ҪõĶ˿ڶӦλΪ1.    ģʽ3.3VʱٶȿԵ13.5MHz(27MHzƵSPIٶ2Ƶ)
	}
}


void  LCD_delay_ms(u16 ms)	// 1~65535
{
	u16 i;
	do
	{
		i = MAIN_Fosc / 6000;
		while(--i)	;
	}while(--ms);
}

//******************************************
void OLED_WriteData(u8 dat)			//write display data to LCD
{
	P_OLED_DC = 1;
	P_OLED_CS = 0;
	SPDAT = dat;	//һֽ
	while((SPSTAT & SPIF)==0)	;			//ȴ
	SPSTAT = 0x80 + 0x40;			//0 SPIFWCOL־
	P_OLED_CS = 1;
}

//******************************************
void	OLED_WriteCMD(u8 cmd)
{
	P_OLED_DC = 0;
	P_OLED_CS = 0;
	SPDAT = cmd;	//һֽ
	while((SPSTAT & SPIF)==0)	;			//ȴ
	SPSTAT = 0x80 + 0x40;			//0 SPIFWCOL־
	P_OLED_CS = 1;
	P_OLED_DC = 1;
}

//========================================================================
// : void Set_Dot_Addr_LCD(int x,int y)
// : LCDʵϵϵXYӦRAMַ
// : x 		X
//		 y 		Y
// : 
// ע: õǰַΪ׼
// 汾:
//      2007/04/10      First version
//========================================================================
void Set_Dot_Addr(u8 x,u8 y)
{
	OLED_WriteCMD((u8)(0xb0 + y));		//ҳ0~7
	OLED_WriteCMD((x >> 4)  | 0x10);	//0~127 nibble
	OLED_WriteCMD(x & 0x0f);			//0~127 nibble
}


//******************************************
void FillPage(u8 y,u8 color)			//Clear Page LCD RAM
{
	u8 j;
	Set_Dot_Addr(0,y);
	for(j=0; j<128; j++)	OLED_WriteData(color);
}

//******************************************
void FillAll(u8 color)			//Clear CSn LCD RAM
{
	u8 i;
	for(i=0; i<8; i++)	FillPage(i,color);
}



//******************************************
void Initialize_OLED(void)	//initialize OLED
{
	SPI_Config(3, 0);	//(SPI_io, SPI_speed), : 	SPI_io: лIO(SS MOSI MISO SCLK), 0: лP1.4 P1.5 P1.6 P1.7,  1: лP2.4 P2.5 P2.6 P2.7, 2: лP4.0 P4.1 P4.2 P4.3,  3: лP3.5 P3.4 P3.3 P3.2,
						//								SPI_speed: SPIٶ, 0: fosc/4,  1: fosc/8,  2: fosc/16,  3: fosc/2
	HSSPI_CFG2 = 0x40;	//MOSI MISO, P3.3MOSI

	P1n_standard(Pin1);			// SPIΪ׼˫, SPIͿź
	PullUpEnable(P1PU, Pin1);	// ˿ڲ     PxPU, ҪõĶ˿ڶӦλΪ1
	P3n_standard(0x2c);			// SPIΪ׼˫, SPIͿź
	PullUpEnable(P3PU, 0x2c);	// ˿ڲ     PxPU, ҪõĶ˿ڶӦλΪ1
	P4n_standard(Pin7);			// SPIΪ׼˫, SPIͿź
	PullUpEnable(P4PU, Pin7);	// ˿ڲ     PxPU, ҪõĶ˿ڶӦλΪ1

	P_OLED_CS  = 1;
	P_OLED_RST = 1;
	P_OLED_DC  = 1;
	P_OLED_DIN = 1;
	P_OLED_CLK = 1;

	P_OLED_RST = 0;
	LCD_delay_ms(100);
	P_OLED_RST = 1;
	LCD_delay_ms(100);


	OLED_WriteCMD(0xAE);     //Set Display Off

	OLED_WriteCMD(0xd5);     //display divide ratio/osc. freq. mode
	OLED_WriteCMD(0x80);     //

	OLED_WriteCMD(0xA8);     //multiplex ration mode:63
	OLED_WriteCMD(0x3F);

	OLED_WriteCMD(0xD3);     //Set Display Offset
	OLED_WriteCMD(0x00);

	OLED_WriteCMD(0x40);     //Set Display Start Line

	OLED_WriteCMD(0x8D);     //Set Display Offset
	OLED_WriteCMD(0x14);

	OLED_WriteCMD(0xA1);     //Segment Remap

	OLED_WriteCMD(0xC8);     //Sst COM Output Scan Direction

	OLED_WriteCMD(0xDA);     //common pads hardware: alternative
	OLED_WriteCMD(0x12);

	OLED_WriteCMD(0x81);     //contrast control
	OLED_WriteCMD(0xCF);

	OLED_WriteCMD(0xD9);	    //set pre-charge period
	OLED_WriteCMD(0xF1);

	OLED_WriteCMD(0xDB);     //VCOM deselect level mode
	OLED_WriteCMD(0x40);	    //set Vvcomh=0.83*Vcc

	OLED_WriteCMD(0xA4);     //Set Entire Display On/Off

	OLED_WriteCMD(0xA6);     //Set Normal Display

	OLED_WriteCMD(0xAF);     //Set Display On

	FillAll(0);
}


//******************************************

void WriteAscii6x8(u8 x,u8 y, u8 number)
{
	u8 const *p;
	u8 i;

	if(x > (128-5))	return;
	if(y >= 8)	return;
	p = (u16)number * 6 + ASCII6x8;

	Set_Dot_Addr(x,y);
	for(i=0; i<6; i++)
	{
		OLED_WriteData(*p);
		p++;
	}
}

//=====================================================
void WriteHZ16(u8 x, u8 y, u16 hz)	//ָλдһ, xΪĵ0~127, yΪҳ0~7, hzΪҪдĺ.
{
	u8 const *p;
	u8 i;

	if(x > (128-16))	return;
	if(y > 6)			return;
	p = hz * 32 + HZK16;
	Set_Dot_Addr(x, y);
	for(i=0; i<16; i++)		{	OLED_WriteData(*p);	p++;}

	Set_Dot_Addr(x, (u8)(y+1));
	for(i=0; i<16; i++)		{	OLED_WriteData(*p);	p++;}
}



void	printf_ASCII_text(u8 x, u8 y, u8 *ptr)	//д10ASCII(10*6+9=69ֽ)ʱ430us@24MHZ
{
	u8  c;

	for (;;)
	{
        c = *ptr;
		if(c == 0)		return;	//ֹͣ0
		if(c < 0x80)			//ASCII
		{
			WriteAscii6x8(x,y,c);
			x += 6;
		}
		ptr++;
	}
}

//******************************************
void WriteAscii_10x24(u8 x, u8 y, u8 chr)	//ָλдһASCIIַ, xΪĵ0~127, yΪҳ0~7, chrΪҪдַ
{
	u8 const *p;
	u8 i;

	if(x > (128-10))	return;
	if(y >= 6)			return;
	p = (u16)chr * 30 + ASCII10x24;

	Set_Dot_Addr(x, y);
	for(i=0; i<10; i++)		{	OLED_WriteData(*p);	p++;	}

	Set_Dot_Addr(x, (u8)(y+1));
	for(i=0; i<10; i++)		{	OLED_WriteData(*p);	p++;	}

	Set_Dot_Addr(x, (u8)(y+2));
	for(i=0; i<10; i++)		{	OLED_WriteData(*p);	p++;	}
}

//******************************************
void WriteDot_3x3(u8 x, u8 y)	//ָλдһС, xΪĵ0~127, yΪҳ0~7
{
	if(x > (128-3))	return;
	if(y >= 8)		return;

	Set_Dot_Addr(x, y);
	OLED_WriteData(0x38);
	OLED_WriteData(0x38);
	OLED_WriteData(0x38);
}


//************ ӡASCII 10x24Ӣַ *************************
void	printf_ascii_10x24(u8 x, u8 y, u8 const *ptr)	//xΪĵ0~127, yΪҳ0~7, *ptrΪҪӡַָ, 2.
{
    u8 c;

	for (;;)
	{
		if(x > (128-10))	return;
		if(y > 5)			return;
		c = *ptr;
		if(c == 0)		return;	//ֹͣ0
		if((c >= '0') && (c <= '9'))			//ASCII
		{
			WriteAscii_10x24(x,y,(u8)(c-'0'));
			x += 12;
		}
		else if(c == '.')
		{
			WriteDot_3x3(x,(u8)(y+2));
			x += 6;
		}
		else if(c == ' ')	//ʾո
		{
			WriteAscii_10x24(x,y,11);
			x += 12;
		}
		else if(c == '-')	//ʾո
		{
			WriteAscii_10x24(x,y,10);
			x += 12;
		}
			ptr++;
	}
}

//DMA_SPI_CR 	SPI_DMAƼĴ
#define		DMA_ENSPI		(1<<7)	// SPI DMAʹܿλ    bit7, 0:ֹSPI DMAܣ  1SPI DMAܡ
#define		SPI_TRIG_M		(1<<6)	// SPI DMAģʽλbit6, 0:д0Ч          1д1ʼSPI DMAģʽ
#define		SPI_TRIG_S		(0<<5)	// SPI DMAӻģʽλbit5, 0:д0Ч          1д1ʼSPI DMAӻģʽ
#define		SPI_CLRFIFO		1		// SPI DMAFIFOλbit0, 0:д0Ч          1д1λFIFOָ롣


//DMA_SPI_CFG 	SPI_DMAüĴ
#define		DMA_SPIIE	(1<<7)	// SPI DMAжʹܿλbit7, 0:ֹSPI DMAжϣ     1жϡ
#define		SPI_ACT_TX	(1<<6)	// SPI DMAݿλbit6, 0:ֹSPI DMAݣֻʱӲݣӻҲ. 1͡
#define		SPI_ACT_RX	(0<<5)	// SPI DMAݿλbit5, 0:ֹSPI DMAݣֻʱӲݣӻҲ. 1ա
#define		DMA_SPIIP	(0<<2)	// SPI DMAжȼλbit3~bit2, ()0~3().
#define		DMA_SPIPTY	0		// SPI DMA߷ȼλbit1~bit0, ()0~3().

//DMA_SPI_CFG2 	SPI_DMAüĴ2
#define		SPI_WRPSS	(0<<2)	// SPI DMAʹSSſλbit2, 0: SPI DMA̲ԶSSš  1ԶSSš
#define		SPI_SSS	    0		// SPI DMAԶSSѡλbit1~bit0, 0: P1.4,  1P2.4,  2: P4.0,  3:P3.5

//DMA_SPI_STA 	SPI_DMA״̬Ĵ
#define		SPI_TXOVW	(1<<2)	// SPI DMAݸǱ־λbit2, 0.
#define		SPI_RXLOSS	(1<<1)	// SPI DMAݶ־λbit1, 0.
#define		DMA_SPIIF	1		// SPI DMAж־λbit0, 0.

//HSSPI_CFG  SPIüĴ
#define		SS_HOLD		(3<<4)	//ģʽʱSSźŵHOLDʱ䣬 0~15, Ĭ3. DMAлNϵͳʱӣSPIٶΪϵͳʱ/2ʱִDMASS_HOLDSS_SETUPSS_DACTô2ֵ.
#define		SS_SETUP		3	//ģʽʱSSźŵSETUPʱ䣬0~15, Ĭ3. DMAвӰʱ䣬       SPIٶΪϵͳʱ/2ʱִDMASS_HOLDSS_SETUPSS_DACTô2ֵ.

//HSSPI_CFG2  SPIüĴ2
#define		SPI_IOSW	(1<<6)	//bit6:MOSIMISOλ01
#define		HSSPIEN		(0<<5)	//bit5:SPIʹλ0رոģʽ1ʹܸģʽ
#define		FIFOEN		(1<<4)	//bit4:SPIFIFOģʽʹλ0رFIFOģʽ1ʹFIFOģʽʹFIFOģʽDMAм13ϵͳʱ䡣
#define		SS_DACT			3	//bit3~0:ģʽʱSSźŵDEACTIVEʱ䣬0~15, Ĭ3, ӰDMAʱ.  SPIٶΪϵͳʱ/2ʱִDMASS_HOLDSS_SETUPSS_DACTô2ֵ.


void	SPI_DMA_TRIG(u8 xdata *TxBuf)
{
				//@40MHz, Fosc/4, 200ֽ258us100ֽ  130us50ֽ66usNֽںʱ N*1.280+2 us, 51Tһֽڣ״̬19T, ʱ32T.
				//@40MHz, Fosc/2, 200ֽ177us100ֽ 89.5us50ֽ46usNֽںʱ N*0.875+2 us, 35Tһֽڣ״̬19T, ʱ16T.
				//@40MHz, Fosc/2, SPI DMAһֽ, FIFO=1, HOLD=0ʱ16+3=19T(0.475us), HOLD=3ʱ16+6=22T(0.55us).
				//@40MHz, Fosc/4, SPI DMAһֽ, FIFO=1, HOLD=0ʱ32+3=35T(0.875us), HOLD=3ʱ32+6=38T(0.95us).
	HSSPI_CFG  = SS_HOLD | SS_SETUP;	//SS_HOLDNϵͳʱ, SS_SETUPûʱӡOLED 40MHzʱSS_HOLDΪ0
	HSSPI_CFG2 = SPI_IOSW | FIFOEN | SS_DACT;	//FIFOENFIFOС13ʱ. @40MHz FIFOEN=1, SS_HOLD=0ʱ523us @2T, 943us @4T;    FIFOEN=1, SS_HOLD=3ʱ600us @2T, 1020us @4T.

	SPI_TxAddr   = (u16)TxBuf;		//Ҫݵ׵ַ
	DMA_SPI_ITVH = 0;
	DMA_SPI_ITVL = 0;
	DMA_SPI_STA  = 0;
	DMA_SPI_CFG  = DMA_SPIIE | SPI_ACT_TX | SPI_ACT_RX | DMA_SPIIP | DMA_SPIPTY;
	DMA_SPI_CFG2 = SPI_WRPSS | SPI_SSS;

	P_OLED_CS = 0;
	B_TxCmd   = 0;		//ѷ־
	SPI_TxCnt = 0;		//SPI DMAʹ, һ128ֽ, һ8
	B_SPI_DMA_busy = 1;	//־SPI-DMAæSPI DMAж˱־ʹSPI DMAǰҪȷϴ˱־Ϊ0
	DMA_SPI_STA = DMA_SPIIF;	//SPI DMAжϣ
}



//========================================================================
// : void SPI_DMA_ISR (void) interrupt DMA_SPI_VECTOR
// :  SPI_DMAжϺ.
// : none.
// : none.
// 汾: V1.0, 2024-1-5
//========================================================================
void SPI_DMA_ISR (void) interrupt USER_VECTOR//DMA_SPI_VECTOR
{
	if(SPI_TxCnt >= 8)	//жϷǷ,  1.46ms @40MHz SPI-4T, 1.04ms @40MHz SPI-2T.
	{
		DMA_SPI_CR = 0;			//رSPI DMA
		B_SPI_DMA_busy = 0;		//SPI-DMAæ־SPI DMAж˱־ʹSPI DMAǰҪȷϴ˱־Ϊ0
		SPSTAT = 0x80 + 0x40;	//0 SPIFWCOL־
		HSSPI_CFG2 = SPI_IOSW | SS_DACT;	//ʹSPIѯжϷʽʱҪֹFIFO
		P_OLED_CS = 1;
	}
	else		//Ҫ
	{
		if(!B_TxCmd)	//ûзõַȷõַ
		{
			B_TxCmd = 1;	//ָʾѷַ
			CmdTmp[0] = (u8)(0xb0 + SPI_TxCnt);
			CmdTmp[1] = (u8)(((0>>4) & 0x0f) + 0x10); //еַĸ4 λ
			CmdTmp[2] = 0 & 0x0f;		//еַĵ4 λ

			P_OLED_DC = 0;	//д
			DMA_SPI_TXAH = (u8)((u16)CmdTmp >> 8);	//SPI DMA׵ַ
			DMA_SPI_TXAL = (u8)CmdTmp;
			DMA_SPI_AMTH = 0;				//ôֽ(8λ),	ôֽ = N+1
			DMA_SPI_AMT  = 3-1;				//ôֽ(8λ).
			DMA_SPI_CR   = DMA_ENSPI | SPI_TRIG_M | SPI_TRIG_S | SPI_CLRFIFO;	//SPI DMA
		}
		else
		{
			B_TxCmd = 0;	//ѷַ
			P_OLED_DC = 1;	//д
			DMA_SPI_TXAH = (u8)(SPI_TxAddr >> 8);	//SPI DMA׵ַ
			DMA_SPI_TXAL = (u8)SPI_TxAddr;
			DMA_SPI_AMTH = 0;				//ôֽ(8λ),	ôֽ = N+1
			DMA_SPI_AMT  = 128-1;			//ôֽ(8λ).
			DMA_SPI_CR   = DMA_ENSPI | SPI_TRIG_M | SPI_TRIG_S | SPI_CLRFIFO;	//SPI DMA
			SPI_TxAddr  += 128;	//Ҫݵ׵ַ, һDMA16ֽ
			SPI_TxCnt++;		//ʹ+1
		}
	}

	DMA_SPI_STA = 0;		//жϱ־
}


//====================================================================================
u8	xdata DisTmp[1024];	//ʾ壬ҪʾݷԴDMA. LCM DMA4ֽڶ⣬ﶨλԵַΪ4ı


//******************************************


void main(void)
{
	u16	i;

	EAXSFR();	//չĴ
	WTST  = 0;
	CKCON = 0;


	P0M1 = 0;	P0M0 = 0;	//Ϊ׼˫
	P1M1 = 0;	P1M0 = 0;	//Ϊ׼˫
	P2M1 = 0;	P2M0 = 0;	//Ϊ׼˫
	P3M1 = 0;	P3M0 = 0;	//Ϊ׼˫
	P4M1 = 0;	P4M0 = 0;	//Ϊ׼˫
	P5M1 = 0;	P5M0 = 0;	//Ϊ׼˫
	P6M1 = 0;	P6M0 = 0;	//Ϊ׼˫
	P7M1 = 0;	P7M0 = 0;	//Ϊ׼˫

	Initialize_OLED();
	EA = 1;

	while(1)
	{
		for(i=0; i<1024; i++)	DisTmp[i] = 0;	//Դ
		SPI_DMA_TRIG(DisTmp);
		while(B_SPI_DMA_busy);	//ȴSPI DMA

		printf_ASCII_text(0, 0, "  OLED12864 SSD1306");
		for(i=0; i<8; i++)	WriteHZ16((u8)(i*16),2,i);
		printf_ascii_10x24(0,5,"-12.345 678");
		LCD_delay_ms(3000);

		for(i=0; i<1024; i++)	DisTmp[i] = gImage_picture1[i];	//ͼƬװصԴ
		SPI_DMA_TRIG(DisTmp);	// @40MHz FIFOEN=1, SS_HOLD=0ʱ523us @2T, 943us @4T;
		LCD_delay_ms(3000);

		for(i=0; i<1024; i++)	DisTmp[i] = gImage_picture2[i];	//ͼƬװصԴ
		SPI_DMA_TRIG(DisTmp);	// @40MHz FIFOEN=1, SS_HOLD=0ʱ523us @2T, 943us @4T;
		LCD_delay_ms(3000);
	}
}




